import 'dart:convert';
import 'dart:io';
import 'package:admin_desktop/application/income/income_state.dart';
import 'package:admin_desktop/domain/models/response/income_cart_response.dart';
import 'package:admin_desktop/domain/models/response/income_statistic_response.dart';
import 'package:admin_desktop/presentation/components/custom_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_esc_pos_utils/flutter_esc_pos_utils.dart';
import 'package:flutter_pos_printer_platform_image_3/flutter_pos_printer_platform_image_3.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_mini_button.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../../order_detail/print_page.dart';


class GenerateIncomeCheckPage extends StatefulWidget {
  final IncomeCartResponse? incomeCart;
  final IncomeStatisticResponse incomeStatistic;
  final IncomeState state;
  const GenerateIncomeCheckPage({super.key, required this.incomeCart,required this.incomeStatistic,required this.state});

  @override
  State<GenerateIncomeCheckPage> createState() => _GenerateIncomeCheckPageState();
}

class _GenerateIncomeCheckPageState extends State<GenerateIncomeCheckPage> {
  @override
  Widget build(BuildContext context) {
    const utf8Encoder = Utf8Encoder();
    utf8Encoder.convert("привет");
    return Container(
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(10),
      ),
      padding: REdgeInsets.symmetric(horizontal: 14, vertical: 16),
      child: SingleChildScrollView(
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(AppHelpers.getTranslation(TrKeys.income),
                style: Style.interMedium(size: 20)),
            Text(TimeService.dateFormatYMDHm(DateTime.now()),style:  Style.interNormal(size: 12),),
            12.verticalSpace,
           CustomLine(),
            12.verticalSpace,
            Row(
              children: [
                SizedBox(
                  width: 120.w,
                  child: Text(AppHelpers.getTranslation(TrKeys.shopName),
                      style: Style.interRegular(size: 14)),
                ),
                Flexible(
                  child: Text(LocalStorage.getShop()?.translation?.title ?? "",
                      style: Style.interRegular(size: 14),textAlign: TextAlign.end,),
                )
              ],
            ),
            8.verticalSpace,
            Row(
              children: [
                Expanded(
                  child: Text(AppHelpers.getTranslation(TrKeys.selectDate),
                      style: Style.interRegular(size: 14)),
                ),
                Text("${TimeService.dateFormat(widget.state.start)}-${TimeService.dateFormat(widget.state.end)}",
                    style: Style.interRegular(size: 12))
              ],
            ),
            10.verticalSpace,
            CustomLine(),
            12.verticalSpace,
            Row(
              children: [
                SizedBox(
                  width: 112.w,
                  child: Text(AppHelpers.getTranslation(TrKeys.revenue),
                      style: Style.interRegular(size: 14)),
                ),
                Spacer(),
                Text(AppHelpers.numberFormat(number: widget.incomeCart?.revenue),
                    style: Style.interRegular(size: 14))
              ],
            ),
            8.verticalSpace,
            Row(
              children: [
                SizedBox(
                  width: 112.w,
                  child: Text(AppHelpers.getTranslation(TrKeys.orders),
                      style: Style.interRegular(size: 14)),
                ),
                Spacer(),
                Text(
                    AppHelpers.numberFormat(number: widget.incomeCart?.orders),
                    style: Style.interRegular(size: 14))
              ],
            ),
            8.verticalSpace,
            Row(
              children: [
                SizedBox(
                  width: 112.w,
                  child: Text(AppHelpers.getTranslation(TrKeys.average),
                      style: Style.interRegular(size: 14)),
                ),
                Spacer(),
                Text(
                    AppHelpers.numberFormat(number: widget.incomeCart?.average),
                    style: Style.interRegular(size: 14))
              ],
            ),
20.verticalSpace,
            CustomLine(),
            20.verticalSpace,
            Row(
              children: [
                SizedBox(
                  width: 112.w,
                  child: Text(AppHelpers.getTranslation(TrKeys.accepted),
                      style: Style.interNormal(size: 14)),
                ),
                Spacer(),
                Text(
                  AppHelpers.numberFormat(number: widget.incomeStatistic.accepted?.sum),
                  style: Style.interRegular(size: 14),
                )
              ],
            ),

            Column(
              children: [
                10.verticalSpace,
                Row(
                  children: [
                    Text(
                      AppHelpers.getTranslation(TrKeys.ready),
                      style: Style.interNormal(size: 14),
                    ),
                    const Spacer(),
                    Text(
                      AppHelpers.numberFormat(number: widget.incomeStatistic.ready?.sum),
                      style: Style.interRegular(size: 14),
                    )
                  ],
                ),
              ],
            ),

              Column(
                children: [
                  10.verticalSpace,
                  Row(
                    children: [
                      Text(
                        AppHelpers.getTranslation(TrKeys.onAWay),
                        style: Style.interNormal(size: 14),
                      ),
                      const Spacer(),
                      Text(
                        AppHelpers.numberFormat(number: widget.incomeStatistic.onAWay?.sum),
                        style: Style.interRegular(size: 14),
                      )
                    ],
                  ),
                ],
              ),

              Column(
                children: [
                  10.verticalSpace,
                  Row(
                    children: [
                      Text(
                        AppHelpers.getTranslation(TrKeys.delivered),
                        style: Style.interNormal(size: 14),
                      ),
                      const Spacer(),
                      Text(
                        AppHelpers.numberFormat(number: widget.incomeStatistic.delivered?.sum),
                        style: Style.interRegular(size: 14),
                      )
                    ],
                  ),
                ],
              ),

              Column(
                children: [
                  10.verticalSpace,
                  Row(
                    children: [
                      Text(
                        AppHelpers.getTranslation(TrKeys.canceled),
                        style: Style.interNormal(size: 14),
                      ),
                      const Spacer(),
                      Text(
                        AppHelpers.numberFormat(number: widget.incomeStatistic.canceled?.sum),
                        style: Style.interRegular(size: 14),
                      )
                    ],
                  ),
                ],
              ),

          10.verticalSpace,
            CustomLine(),
            26.verticalSpace,

            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Expanded(
                  child: LoginButton(
                      title: AppHelpers.getTranslation(TrKeys.print),
                      onPressed: () async {
                        if(LocalStorage.getPrinterData()==null){
                          final bytes = await _getBytes();
                          if (context.mounted) {
                            AppHelpers.showAlertDialog(
                                context: context, child: PrintPage(bytes: bytes));
                          }
                        }else {
                          final bytes = await _getBytes();
                          _printEscPos(
                            bytes,
                          );
                        }
                      }),
                ),
                10.horizontalSpace,
                CustomMiniButton(
                  size: 56,
                  onTap: () async {
                    final bytes = await _getBytes();
                    if (context.mounted) {
                      AppHelpers.showAlertDialog(
                          context: context, child: PrintPage(bytes: bytes));
                    }
                    // ignore: deprecated_member_use
                  },
                  icon: Remix.settings_5_fill,
                  iconColor: Style.white.withOpacity(0.7),
                  color: Style.primary,
                )
              ],
            ),
          ],
        ),
      ),
    );
  }

  var printerManager = PrinterManager.instance;

  List<int>? pendingTask;

  final _reconnect = false;

  final BTStatus _currentStatus = BTStatus.none;

  void _printEscPos(List<int> bytes,) async {
    final profile = await CapabilityProfile.load();
    final generator = Generator(PaperSize.mm58, profile);
    var connectedTCP = false;
    if (LocalStorage.getPrinterData() == null) return;
    var bluetoothPrinter = LocalStorage.getPrinterData()!;

    switch (bluetoothPrinter.typePrinter) {
      case PrinterType.usb:
        debugPrint("");
        bytes += generator.feed(2);
        bytes += generator.cut();
        await printerManager.connect(
            type: bluetoothPrinter.typePrinter,
            model: UsbPrinterInput(
                name: bluetoothPrinter.deviceName,
                productId: bluetoothPrinter.productId,
                vendorId: bluetoothPrinter.vendorId));
        pendingTask = null;
        break;
      case PrinterType.bluetooth:
        bytes += generator.cut();
        await printerManager.connect(
            type: bluetoothPrinter.typePrinter,
            model: BluetoothPrinterInput(
                name: bluetoothPrinter.deviceName,
                address: bluetoothPrinter.address!,
                isBle: bluetoothPrinter.isBle ?? false,
                autoConnect: _reconnect));
        pendingTask = null;
        if (Platform.isAndroid) pendingTask = bytes;
        break;
      case PrinterType.network:
        bytes += generator.feed(2);
        bytes += generator.cut();
        connectedTCP = await printerManager.connect(
            type: bluetoothPrinter.typePrinter,
            model: TcpPrinterInput(ipAddress: bluetoothPrinter.address!));
        if (!connectedTCP) debugPrint(' --- please review your connection ---');
        break;
    }
    if (bluetoothPrinter.typePrinter == PrinterType.bluetooth &&
        Platform.isAndroid) {
      if (_currentStatus == BTStatus.connected) {
        printerManager.send(type: bluetoothPrinter.typePrinter, bytes: bytes);
        pendingTask = null;
      }
    } else {
      printerManager.send(type: bluetoothPrinter.typePrinter, bytes: bytes);
    }
  }

  Future<List<int>> _getBytes() async {
    List<int> bytes=[];
    String customDivider = "-------------------------------------------";
    String customLine = "___________________________________________";
    String customSpace = "  ";
    final profile = await CapabilityProfile.load(name: 'XP-N160I');

    final generator = Generator(PaperSize.mm80, profile);

    bytes += generator.setGlobalCodeTable('CP1252');
    bytes += generator.setStyles(const PosStyles(align: PosAlign.center));
    bytes += generator.text(AppHelpers.getTranslation(TrKeys.income),
        styles: const PosStyles(align: PosAlign.center, bold: true));

    bytes += generator.text(TimeService.dateFormatYMDHm(DateTime.now()),
        styles: const PosStyles(align: PosAlign.center));
    bytes += generator.text(customDivider);
    bytes += generator.row([
      PosColumn(
          width: 7,
          text: customSpace + AppHelpers.getTranslation(TrKeys.shopName),
          styles: const PosStyles(align: PosAlign.left, codeTable: 'CP1252')),
      PosColumn(
          width: 5,
          text: LocalStorage.getShop()?.translation?.title ?? "",
          styles: const PosStyles(align: PosAlign.right, codeTable: 'CP1252')),
    ]);

    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.selectDate),
        styles: const PosStyles(align: PosAlign.left),
      ),
      PosColumn(
        width: 6,
        text: "${TimeService.dateFormat(widget.state.start)}-${TimeService.dateFormat(widget.state.end)}",
        styles: const PosStyles(align: PosAlign.right),
      ),
    ]);
  bytes+=generator.text(customDivider);

    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.revenue),
        styles: const PosStyles(align: PosAlign.left),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(
        number: widget.incomeCart?.revenue),
        styles: const PosStyles(align: PosAlign.right),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.order),
        styles: const PosStyles(align: PosAlign.left),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(
            number: widget.incomeCart?.orders),
        styles: const PosStyles(align: PosAlign.right),
      ),
    ]);

    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.average),
        styles: const PosStyles(align: PosAlign.left,),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(number: widget.incomeCart?.average),
        styles: const PosStyles(align: PosAlign.right,),
      ),
    ]);
    bytes+=generator.text(customLine);
    bytes+=generator.text(customDivider);
    List<int> utf8Bytes = utf8.encode("привет");
    Uint8List data = Uint8List.fromList(utf8Bytes);

    bytes += generator.row([
      PosColumn(
        width: 6,
      textEncoded: data,
      //  text: customSpace + TrKeys.accepted,   // "привет"
        styles: const PosStyles(align: PosAlign.left, bold: true,codeTable: "UTF-8"),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(
            number: widget.incomeStatistic.accepted?.sum),
        styles: const PosStyles(align: PosAlign.right, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.ready),
        styles: const PosStyles(align: PosAlign.left, bold: true),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(
            number: widget.incomeStatistic.ready?.sum),
        styles: const PosStyles(align: PosAlign.right, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.onAWay),
        styles: const PosStyles(align: PosAlign.left, bold: true),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(number: widget.incomeStatistic.onAWay?.sum),
        styles: const PosStyles(align: PosAlign.right, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.delivered),
        styles: const PosStyles(align: PosAlign.left, bold: true),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(number: widget.incomeStatistic.delivered?.sum),
        styles: const PosStyles(align: PosAlign.right, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        width: 6,
        text: customSpace + AppHelpers.getTranslation(TrKeys.canceled),
        styles: const PosStyles(align: PosAlign.left, bold: true),
      ),
      PosColumn(
        width: 6,
        text: AppHelpers.numberFormat(number: widget.incomeStatistic.canceled?.sum),
        styles: const PosStyles(align: PosAlign.right, bold: true),
      ),
    ]);
    bytes += generator.text(customDivider);
    bytes += generator.text(AppHelpers.getTranslation(TrKeys.thankYou));

    return bytes;
  }
}
